<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Slider;
use App\Models\Category;
use App\Models\Product;

class CustomerHomeController extends Controller
{
    public function index()
    {
        $sliders = Slider::where('status', true)->get();
        // Fetch top level categories
        $categories = Category::where('status', true)->whereNull('parent_id')->with('children')->get();

        // Attach 4 active products to each category
        $categories->each(function ($category) {
            $products = Product::where('status', true)
                ->where('category_id', $category->id)
                ->with(['images', 'variations.options'])
                ->inRandomOrder()
                ->take(4)
                ->get();

            $products->transform(function ($product) {
                $firstVariation = $product->variations->first();
                $product->attribute_value = $firstVariation?->options->first()?->attribute_value ?? '';
                return $product;
            });

            $category->setRelation('products', $products);
        });

        // Featured products: logic can vary, for now taking random 6 active products
        $featuredProducts = Product::where('status', true)
            ->with(['images', 'variations.options'])
            ->inRandomOrder()
            ->take(6)
            ->get();

        $featuredProducts->transform(function ($product) {
            $firstVariation = $product->variations->first();
            $product->attribute_value = $firstVariation?->options->first()?->attribute_value ?? '';
            return $product;
        });

        return response()->json([
            'sliders' => $sliders,
            'categories' => $categories, // Categories now include 'products' list
            'featured_products' => $featuredProducts
        ]);
    }
}
