<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;

class CustomerCategoryController extends Controller
{
    /**
     * Get all categories with their subcategories.
     */
    public function index()
    {
        $categories = Category::where('status', true)
            ->whereNull('parent_id')
            ->with([
                'children' => function ($query) {
                    $query->where('status', true);
                }
            ])
            ->get();

        return response()->json($categories);
    }

    /**
     * Get details of a specific category including its products?
     * Or just meta info. Usually category page fetches products via product filter.
     * Here we just return category info + subcategories.
     */
    public function show($id)
    {
        $category = Category::where('status', true)
            ->with([
                'children' => function ($query) {
                    $query->where('status', true);
                }
            ])
            ->findOrFail($id);

        return response()->json($category);
    }
}
