<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\VideoConsultationBooking;

class VideoConsultationController extends Controller
{
    public function index()
    {
        $bookings = VideoConsultationBooking::latest()->paginate(10);
        return view('admin.consultations.index', compact('bookings'));
    }

    public function updateStatus(Request $request, $id)
    {
        $booking = VideoConsultationBooking::findOrFail($id);
        $booking->update(['status' => $request->status]);
        return redirect()->back()->with('success', 'Status updated successfully.');
    }

    public function destroy($id)
    {
        VideoConsultationBooking::destroy($id);
        return redirect()->back()->with('success', 'Booking deleted successfully.');
    }
}
