<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Models\TaxRate;
use Illuminate\Http\Request;

class TaxRateController extends Controller
{
    public function index()
    {
        $taxRates = TaxRate::latest()->paginate(20);
        return view('admin.settings.tax_rates.index', compact('taxRates'));
    }

    public function create()
    {
        return view('admin.settings.tax_rates.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|unique:tax_rates,name',
            'rate' => 'required|numeric|min:0|max:100',
            'is_active' => 'boolean'
        ]);

        TaxRate::create($request->all());

        return redirect()->route('admin.tax-rates.index')->with('success', 'Tax rate created successfully.');
    }

    public function edit(TaxRate $taxRate)
    {
        return view('admin.settings.tax_rates.edit', compact('taxRate'));
    }

    public function update(Request $request, TaxRate $taxRate)
    {
        $request->validate([
            'name' => 'required|string|unique:tax_rates,name,' . $taxRate->id,
            'rate' => 'required|numeric|min:0|max:100',
            'is_active' => 'boolean'
        ]);

        $taxRate->update($request->all());

        return redirect()->route('admin.tax-rates.index')->with('success', 'Tax rate updated successfully.');
    }

    public function destroy(TaxRate $taxRate)
    {
        $taxRate->delete();
        return redirect()->route('admin.tax-rates.index')->with('success', 'Tax rate deleted successfully.');
    }
}
