<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SystemError;
use Illuminate\Http\Request;

class SystemErrorController extends Controller
{
    public function index()
    {
        $errors = SystemError::with('user')->latest()->paginate(20);
        return view('admin.errors.index', compact('errors'));
    }

    public function show(SystemError $error)
    {
        return view('admin.errors.show', compact('error'));
    }

    public function resolve(SystemError $error)
    {
        $error->update(['is_resolved' => true]);
        return back()->with('success', 'Error marked as resolved.');
    }

    public function destroy(SystemError $error)
    {
        $error->delete();
        return back()->with('success', 'Error log deleted.');
    }

    public function clearAll()
    {
        SystemError::truncate();
        return back()->with('success', 'All error logs cleared.');
    }
}
