<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PromotionalBanner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PromotionalBannerController extends Controller
{
    public function index()
    {
        $banners = PromotionalBanner::latest()->get();
        return view('admin.settings.promotional.index', compact('banners'));
    }

    public function create()
    {
        return view('admin.settings.promotional.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|max:5120',
            'link' => 'nullable|url|max:255',
        ]);

        $path = $request->file('image')->store('promotional', 'public');

        PromotionalBanner::create([
            'image_path' => $path,
            'link' => $request->link,
            'status' => true,
        ]);

        return redirect()->route('admin.settings.promotional.index')->with('success', 'Promotional Banner added successfully.');
    }

    public function edit(PromotionalBanner $banner)
    {
        return view('admin.settings.promotional.edit', compact('banner'));
    }

    public function update(Request $request, PromotionalBanner $banner)
    {
        $request->validate([
            'image' => 'nullable|image|max:5120',
            'link' => 'nullable|url|max:255',
        ]);

        $data = $request->only(['link']);

        if ($request->has('status')) {
            $data['status'] = $request->boolean('status');
        }

        if ($request->hasFile('image')) {
            if ($banner->image_path) {
                Storage::disk('public')->delete($banner->image_path);
            }
            $data['image_path'] = $request->file('image')->store('promotional', 'public');
        }

        $banner->update($data);

        return redirect()->route('admin.settings.promotional.index')->with('success', 'Promotional Banner updated successfully.');
    }

    public function toggleStatus(PromotionalBanner $banner)
    {
        $banner->status = !$banner->status;
        $banner->save();
        return back()->with('success', 'Status updated.');
    }

    public function destroy(PromotionalBanner $banner)
    {
        if ($banner->image_path) {
            Storage::disk('public')->delete($banner->image_path);
        }
        $banner->delete();
        return back()->with('success', 'Promotional Banner deleted successfully.');
    }
}
