<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\GeneralSetting;
use Illuminate\Http\Request;

class PolicyController extends Controller
{
    public function show()
    {
        $settings = GeneralSetting::first();
        if (!$settings) {
            $settings = GeneralSetting::create([]);
        }
        return view('admin.settings.policy', compact('settings'));
    }

    public function update(Request $request)
    {
        $settings = GeneralSetting::first();
        if (!$settings) {
            $settings = GeneralSetting::create([]);
        }

        $request->validate([
            'return_window_days' => 'nullable|integer|min:0',
        ]);

        // Convert textarea newlines to array
        $cancellationRules = $request->cancellation_rules
            ? array_values(array_filter(array_map('trim', explode("\n", $request->cancellation_rules))))
            : null;

        $refundRules = $request->refund_rules
            ? array_values(array_filter(array_map('trim', explode("\n", $request->refund_rules))))
            : null;

        $settings->update([
            'cancellation_rules' => $cancellationRules,
            'refund_rules' => $refundRules,
            'return_window_days' => $request->return_window_days,
        ]);

        return back()->with('success', 'Policy rules updated successfully.');
    }
}
