<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\GiftCard;
use Illuminate\Http\Request;

class GiftCardController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->get('search');
        $status = $request->get('status');

        $query = GiftCard::with(['creator', 'redeemer'])->latest();

        if ($search) {
            $query->where('code', 'like', "%{$search}%")
                ->orWhere('recipient_email', 'like', "%{$search}%")
                ->orWhereHas('creator', function ($q) use ($search) {
                    $q->where('name', 'like', "%{$search}%")
                        ->orWhere('email', 'like', "%{$search}%");
                });
        }

        if ($status) {
            $query->where('status', $status);
        }

        $giftCards = $query->paginate(20);

        return view('admin.gift_cards.index', compact('giftCards'));
    }
}
