<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use App\Models\Category;

class SampleProductsExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    public function collection()
    {
        // Fetch all subcategories (categories with a parent)
        $subcategories = Category::whereNotNull('parent_id')->with('parent')->where('status', true)->get();

        // Fetch root categories that don't have children (if you allow products directly in root categories)
        // For simplicity, we can also include them, or typically products are in subcats. 
        // Let's assume most products are in subcategories if they exist. 
        // We will just return all leaf nodes effectively.
        // Actually, let's just dump all combinations to be helpful.

        // Combine all: 
        // 1. Subcategories
        // 2. Root categories that have NO subcategories (optional, but good for completeness)

        $rootCategoriesWithoutChildren = Category::whereNull('parent_id')
            ->doesntHave('children')
            ->where('status', true)
            ->get();

        return $subcategories->concat($rootCategoriesWithoutChildren);
    }

    public function headings(): array
    {
        return [
            'Product Name',
            'Category',
            'Sub Category',
            'MRP',
            'Selling Price (SP)',
            'Short Description',
            'Dispatch Days',
            'Stock Quantity',
        ];
    }

    /**
     * @param mixed $row
     *
     * @return array
     */
    public function map($category): array
    {
        // Determine Category and Sub Category names
        if ($category->parent_id) {
            $catName = $category->parent->name;
            $subCatName = $category->name;
        } else {
            $catName = $category->name;
            $subCatName = '';
        }

        return [
            'Sample Product (' . $category->name . ')', // Product Name
            $catName,                                   // Category
            $subCatName,                                // Sub Category
            '1000',                                     // MRP
            '900',                                      // SP
            'Sample description for ' . $category->name,// Short Description
            '2',                                        // Dispatch Days
            '50',                                       // Stock Quantity
        ];
    }
}
