<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Barryvdh\DomPDF\Facade\Pdf;

class GenerateDocsPdf extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:generate-docs-pdf';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate project documentation as PDF';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Generating Project Documentation PDF...');

        try {
            $pdf = Pdf::loadView('admin.documentation_pdf', []);
            $path = public_path('lugani_project_documentation.pdf');
            $pdf->save($path);

            $this->info("Documentation successfully generated at: {$path}");
        } catch (\Exception $e) {
            $this->error("Failed to generate PDF: " . $e->getMessage());
        }
    }
}
