# Lugani Project Documentation

## Overview
Lugani is a comprehensive E-commerce platform built with Laravel. It features a robust layout for standard users (shoppers), a dedicated panel for delivery agents, and a feature-rich admin dashboard for complete store management.

---

## 1. Technology Stack
- **Backend Framework**: Laravel 12.x (PHP 8.2+)
- **Database**: MySQL / SQLite (configurable)
- **Frontend**: Blade Templating, Tailwind CSS, Vanilla JavaScript
- **Key Libraries**:
    - `razorpay/razorpay`: Payment Gateway Integration
    - `maatwebsite/excel`: Bulk Product Import
    - `barryvdh/laravel-dompdf`: PDF Export (Invoices/Lists)

---

## 2. User Roles & Modules

### A. Shop (Public Frontend)
**Target Audience**: Customers/Visitors
- **Product Browsing**:
    - View products by Category and Subcategory.
    - Product Search with Suggestions.
    - Product Details: Description, variations (size/color), pricing, and images.
- **Cart & Checkout**:
    - Add to Cart, Update quantities, Remove items.
    - Apply Coupons and Gift Cards.
    - Secure Checkout Process (Address selection, Payment method).
- **Payment Options**:
    - Cash on Delivery (COD).
    - Online Payment (Razorpay/PhonePe).
    - Wallet Balance usage.
- **Static Pages**: About Us, Contact Us, Policy Pages (Privacy, Shipping, Refund, etc.).
- **Blog & Testimonials**: Read blogs and view customer testimonials.

### B. User Dashboard (Authenticated Customers)
**Routes Prefix**: `/user/*`
- **Authentication**: Login, Registration, Password Reset.
- **Profile Management**: Update name, email, phone, and profile picture.
- **Address Book**: Manage multiple delivery addresses (Add/Edit/Delete).
- **Order History**: View past orders, order status, and download invoices.
- **Wallet System**: View balance and transaction history.
- **Wishlist**: Save products for later, move to cart.
- **Support**:
    - **Tickets**: Create and manage support tickets linked to orders.
    - **Gift Cards**: View purchased/received gift cards.

### C. Delivery Agent Panel
**Routes Prefix**: `/delivery/*`
- **Dashboard**:
    - Overview of assigned, completed, and pending orders.
    - Earnings statistics.
- **Order Management**:
    - View assigned orders with customer details.
    - Update Order Status (e.g., Out for Delivery, Delivered).
- **Profile & KYC**:
    - Update personal details and profile photo.
    - Manage Vehicles and Documents (License, ID Proof).
- **Notification**: Receive system notifications.

### D. Admin Panel
**Routes Prefix**: `/admin/*`
**Security**: Protected by Role-Based Access Control (RBAC).

#### 1. Dashboard
- Analytics overview: Total Sales, Orders, New Customers.
- Recent activity logs.

#### 2. Product Management (`/admin/products`)
- **CRUD Operations**: Create, Read, Update, Delete products.
- **Variations**: Manage sizes, colors, and stock levels.
- **Import/Export**:
    - Bulk Upload via Excel.
    - Export Product List to PDF.
- **Categories**: Manage Categories and Subcategories hierarchy.

#### 3. Sales & Orders (`/admin/orders`)
- **Order Listing**: Filter by status, date, or search.
- **Order Details**: View items, shipping info, and payment status.
- **Actions**:
    - Update Status (Processing, Shipped, Completed, Cancelled).
    - Assign Delivery Agents.
    - Download Invoices.

#### 4. User Management
- **Clients**: View registered customers, their orders, and wallet balance.
- **Administrators/Staff**: Manage system users (`/admin/users`).
- **Roles & Permissions**:
    - Create dynamic roles (e.g., Manager, Editor).
    - Assign granular permissions (e.g., `view_orders`, `create_products`).

#### 5. Delivery Management (`/admin/delivery-agents`)
- **Agents**: List all agents, view profiles, and verify documents.
- **Vehicles**: Monitor agent vehicles.
- **Notifications**: Send custom notifications to agents.

#### 6. Marketing
- **Coupons**: Create percentage or fixed discount codes.
- **Discounts**: Manage automated product discounts.
- **Promotional Banners**: Manage homepage sliders and promotional sections.
- **Subscribers**: View newsletter subscribers.

#### 7. Content Management
- **Blogs**: Write and publish blog posts.
- **Testimonials**: Manage customer testimonials.
- **Ticket System**: Reply to and close user support tickets.
- **Contact Inquiries**: View messages from the "Contact Us" form.

#### 8. Settings
- **General**: Website Name, Logo, Favicon.
- **Payment**: Configure Gateways (Razorpay/PhonePe) and payment methods.
- **Shipping**: Set shipping costs and rules.
- **SEO**: Global SEO settings (Meta tags, keywords).
- **Policies**: Edit content for Privacy Policy, Terms, etc.

---

## 3. Key Features & Highlights
- **Role-Based Access Control (RBAC)**: secure middleware (`permission:slug`) ensures admins only access what they are allowed to.
- **Dynamic Menus**: Mega Menu for categories on the frontend.
- **PDF Generation**: Automated invoice and report generation.
- **Wallet System**: Integrated wallet for refunds and loyalty.
- **Real-time Search**: Search suggestions for products.

---

## 4. Installation & Setup
1. **Clone Repository**:
   ```bash
   git clone <repo-url>
   cd lugani_project
   ```
2. **Install Dependencies**:
   ```bash
   composer install
   npm install
   ```
3. **Environment Setup**:
   ```bash
   cp .env.example .env
   # Configure DB_DATABASE, DB_USERNAME, DB_PASSWORD
   php artisan key:generate
   ```
4. **Database Migration & Seeding**:
   ```bash
   php artisan migrate --seed
   # Seeds Permissions, Roles, Admin User, and Dummy Data
   ```
5. **Run Application**:
   ```bash
   npm run build
   php artisan serve
   ```

---

## 5. Security Measures
- **Middleware**: `auth`, `admin`, `permission` checks.
- **CSRF Protection**: Enabled on all forms.
- **Sanitization**: Input validation on all controller methods.
- **Error Handling**: Custom 403/404/500 Error Pages.
