# Deployment Guide for Niche Ecommerce

This guide outlines the steps to deploy the application to a production server.

## 1. Server Requirements
Ensure your server meets the following requirements:
- **PHP**: ^8.2
- **Database**: MySQL / MariaDB
- **Web Server**: Nginx or Apache
- **Extensions**: BCMath, Ctype, Fileinfo, JSON, Mbstring, OpenSSL, PDO, Tokenizer, XML, Intl.
- **Composer** (if using VPS/SSH)
- **Node.js & NPM** (if building assets on server)

## 2. Preparation (Already done locally)
- Assets have been compiled using `npm run build`.
- Local caches should be cleared before upload.

## 3. Deployment Methods

### Option A: Shared Hosting (cPanel/File Manager)
1. **Zip the Project**: Compress the entire project folder.
   - **Exclude**: `node_modules`, `.git`, `.env` (create a new one on server), `storage/*.key` .
   - **Include**: `vendor` folder (if you cannot run `composer install` on server).
   - **Include**: `public/build` (compiled assets).
2. **Upload**: Upload the zip file to your server's root directory (e.g., one level above `public_html`).
3. **Structure Setup**:
   - Move the contents of the `public/` folder to your `public_html` (or separate public domain folder).
   - Edit `public_html/index.php`:
     ```php
     require __DIR__.'/../Niche_ecommerce/vendor/autoload.php';
     $app = require_once __DIR__.'/../Niche_ecommerce/bootstrap/app.php';
     ```
     (Adjust paths to point to where you extracted the main app files).
4. **Database**:
   - Create a MySQL database and user.
   - Import your local database SQL (export via phpMyAdmin) or run migrations if SSH is available.
5. **Configuration**:
   - Rename `.env.example` to `.env`.
   - Update `APP_URL`, database credentials (`DB_DATABASE`, `DB_USERNAME`, `DB_PASSWORD`), and others.
   - Set `APP_ENV=production` and `APP_DEBUG=false`.
6. **Storage Link**:
   - You may need to recreate the symbolic link for storage.
   - If SSH is available: `php artisan storage:link`.
   - If not, you might need a PHP script to run `symlink()`.

### Option B: VPS / Dedicated Server (with SSH)
1. **Clone/Upload**: `git clone` your repository or upload files.
2. **Permissions**:
   ```bash
   chmod -R 775 storage bootstrap/cache
   chown -R www-data:www-data storage bootstrap/cache
   ```
3. **Install Dependencies**:
   ```bash
   composer install --optimize-autoloader --no-dev
   ```
4. **Environment**:
   ```bash
   cp .env.example .env
   # Edit .env with production credentials
   php artisan key:generate
   ```
5. **Database**:
   ```bash
   php artisan migrate --force
   ```
6. **Optimization**:
   ```bash
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```
7. **Queue Worker** (if applicable):
   - Configure Supervisor to run `php artisan queue:work`.

## 4. Post-Deployment Checks
- Verify that `https://yourdomain.com/admin` loads.
- Check if images (Refund Proofs, Product Images) load correctly. If not, check the `storage` symlink.
- Test checkout and payment gateways in production mode.
