<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Datastream;

class GcsProfile extends \Google\Model
{
  /**
   * Required. The Cloud Storage bucket name.
   *
   * @var string
   */
  public $bucket;
  /**
   * The root path inside the Cloud Storage bucket.
   *
   * @var string
   */
  public $rootPath;

  /**
   * Required. The Cloud Storage bucket name.
   *
   * @param string $bucket
   */
  public function setBucket($bucket)
  {
    $this->bucket = $bucket;
  }
  /**
   * @return string
   */
  public function getBucket()
  {
    return $this->bucket;
  }
  /**
   * The root path inside the Cloud Storage bucket.
   *
   * @param string $rootPath
   */
  public function setRootPath($rootPath)
  {
    $this->rootPath = $rootPath;
  }
  /**
   * @return string
   */
  public function getRootPath()
  {
    return $this->rootPath;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GcsProfile::class, 'Google_Service_Datastream_GcsProfile');
